<?php
session_start();

// Datubāzes savienojuma parametri
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums ar datubāzi neizdevās: " . $conn->connect_error);
}

// Pārbauda, vai lietotājs ir pieslēdzies
$user_id = $_SESSION['user_id'] ?? null;
$first_name = "";
$last_name = "";

if ($user_id) {
    $sql = "SELECT first_name, last_name FROM rb_kvalif_signup_410 WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $first_name = htmlspecialchars($row['first_name']); // Sanitizē izvadi
        $last_name = htmlspecialchars($row['last_name']);
    }

    $stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../css/main.css">
    <title>Sākumlapa</title>
</head>
<body>
<header>
    <nav>
        <ul>
            <li><a href="../php/main.php" class="active">Home</a></li>
            <li><a href="../html/work-hours.html">Darba stundas</a></li>
            <li><a href="../html/material-count.html">Materiālu uzskaite</a></li>
            <li><a href="../html/faq.html">BUJ</a></li>
        </ul>
        <div class="user-info">
            <!-- Profila poga -->
            <button class="profile-btn" onclick="location.href='../php/profile.php'">
                <img src="../icons/user.svg" alt="Lietotāja ikona">
            </button>
            <a href="../html/log-in.html" class="logout">Izrakstīties</a>
        </div>
    </nav>
</header>
<div class="content">
    <!-- Personalizēts sveiciena ziņojums -->
    <h2 id="welcome-message">Laipni lūdzam, <?php echo $first_name . " " . $last_name; ?>!</h2>

    <!-- Kartiņu konteiners -->
    <div class="card-container">
        <div class="card" onclick="location.href='../html/work-hours.html'">
            <img src="../icons/work-hours.svg" alt="Darba stundu ikona">
            <p>Darba stundas</p>
        </div>
        <div class="card" onclick="location.href='../html/material-count.html'">
            <img src="../icons/material-count.svg" alt="Materiālu uzskaites ikona">
            <p>Materiālu uzskaite</p>
        </div>
        <div class="card" onclick="location.href='../html/faq.html'">
            <img src="../icons/faq.svg" alt="BUJ ikona">
            <p>BUJ</p>
        </div>
    </div>
</div>
</body>
</html>